/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.hardware.Logo7;

public class ConstantBlock
extends Block {
    static final long serialVersionUID = 6694787466984120702L;
    private int constantBlockSerializedDataVersion = 1;
    protected transient Interpreter fInterpreter;

    public ConstantBlock() {
    }

    public ConstantBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected int getDefaultOrder() {
        return 100;
    }

    public String getNumberString(int blockNumber) {
        String string = blockNumber > 0 ? this.getNumberPrefix() + Integer.toString(blockNumber) : this.getNumberPrefix();
        return string;
    }

    public int getOpcode() throws RuntimeException {
        int opcode = 0;
        try {
            opcode = ((Logo)this.getWiringDiagram().getHardware()).getOpcodeCO(this.getName(), this.getNumber());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(this.getClass() + ">>getOpcode() not implemented");
        }
        return opcode;
    }

    public int getOpcode(Hardware hw, int blockNr) throws IllegalArgumentException {
        return ((Logo)hw).getOpcodeCO(this.getName(), blockNr);
    }

    public String getType() {
        return "Constant";
    }

    public boolean isLeftTerminal() {
        return true;
    }

    public int getVMStartAddress() {
        if (!(this.getHardware() instanceof Logo7)) {
            throw new UnsupportedOperationException();
        }
        return ((Logo7)this.getHardware()).getVMStartAddress(this.getNumberType());
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fInterpreter = interpreter;
    }

    public void synDigitalValueToVM(boolean value) {
        if (this.getVMStartAddress() >= 0) {
            int address = this.getVMStartAddress() + (this.getNumber() - 1) / 8;
            int vmValue = this.fInterpreter.readVM(1, address);
            String biString = Integer.toBinaryString(vmValue);
            StringBuffer sb = new StringBuffer("00000000".substring(0, 8 - biString.length()) + biString);
            sb.replace((8 - this.getNumber() % 8) % 8, (8 - this.getNumber() % 8) % 8 + 1, value ? "1" : "0");
            this.fInterpreter.writeVM(1, address, Integer.parseInt(sb.toString(), 2));
        }
    }

    public void synAnalogValueToVM(double value) {
        if (this.getVMStartAddress() >= 0 && this.fInterpreter != null) {
            int address = this.getVMStartAddress() + (this.getNumber() - 1) / 8 * 2;
            this.fInterpreter.writeVM(2, address, (int)Math.round(value));
        }
    }
}

